<?php
require __DIR__ . '/../db.php';

// Require a logged-in user (magic link user or admin)
$u = current_user($db);
if (!$u) {
    // Not logged in C send them to the main page to sign in
    header('Location: index.php');
    exit;
}

$cols = [
  1 => 'Backlog',
  2 => 'Planned',
  3 => 'In Progress',
  4 => 'Released',
];

$data = [];
foreach ($cols as $sid => $name) {
  $rows = $db->queryAll(
    'SELECT f.*, COALESCE(tv.total_votes,0) AS total_votes, c.name AS category_name
     FROM features f
     LEFT JOIN (SELECT feature_id,COUNT(*) total_votes FROM feature_votes GROUP BY feature_id) tv
       ON tv.feature_id=f.id
     LEFT JOIN categories c ON c.id=f.category_id
     WHERE f.status_id=?
     ORDER BY total_votes DESC, f.created_at DESC',
    [$sid]
  );
  $data[$sid] = $rows;
}
?>
<!doctype html>
<html lang="en">
<head>
<meta name="robots" content="noindex,nofollow">
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width,initial-scale=1" />
<title>Roadmap</title>
<style>
/* Brand + palette */
:root {
  /* Your palette */
  --color-1: #ffffff;
  --color-2: #afbac5;
  --color-3: #7f9aad;
  --color-4: #5c92c1;
  --color-5: #7890a1;

  /* Derived app colors */
  --primary: var(--color-4);
  --primary-dark: #325a8b;      /* deeper AGR blue */
  --bg-soft: #f3f5f8;           /* page background */
  --card-bg: var(--color-1);    /* white cards */
  --column-bg: #eef1f5;         /* column background */
  --border-soft: #dde3ea;
  --text-main: #2f343b;
  --text-muted: #6c7175;        /* cool gray */
}

/* Optional if you have a header on this page */
*{box-sizing:border-box;}
body{
  font-family:system-ui,-apple-system,Segoe UI,Roboto,Ubuntu;
  margin:0;
  background:var(--bg-soft);
  color:var(--text-main);
}
.wrap{
  max-width:1200px;
  margin:24px auto;
  padding:0 16px;
}
h1{margin-bottom:16px}

/* Roadmap board layout */
.board{display:grid;gap:12px}
@media (min-width:900px){
  .board{grid-template-columns:repeat(4,minmax(0,1fr));}
}
.col{
  background:var(--column-bg);
  border-radius:12px;
  padding:8px 8px 12px 8px;
  border:1px solid var(--border-soft);
  min-height:80px;
}
.col h2{
  font-size:16px;
  margin:4px 4px 8px 4px;
  display:flex;
  justify-content:space-between;
  align-items:center;
}
.card{
  background:var(--card-bg);
  border-radius:10px;
  border:1px solid var(--border-soft);
  padding:8px 10px;
  margin:0 4px 8px 4px;
  box-shadow:0 1px 2px rgba(0,0,0,.04);
  font-size:14px;
}
.badge{
  font-size:11px;
  border-radius:999px;
  border:1px solid var(--border-soft);
  padding:2px 6px;
  margin-left:4px;
}
.muted{
  color:var(--text-muted);
  font-size:12px;
}

/* Buttons C uses brand blue variables */
.btn{
  border-radius:999px;
  padding:6px 12px;
  cursor:pointer;
  font-size:14px;
  border:1px solid var(--primary);
  background:var(--primary);
  color:#fff;
  transition:background .15s,border-color .15s,transform .05s;
}
.btn:hover{
  background:var(--primary-dark);
  border-color:var(--primary-dark);
  transform:translateY(-1px);
}

.site-header{
  background:var(--card-bg);
  border-bottom:1px solid var(--border-soft);
  box-shadow:0 2px 4px rgba(0,0,0,.03);
}
.header-inner{
  max-width:1200px;
  margin:0 auto;
  padding:10px 16px;
  display:flex;
  align-items:center;
  gap:16px;
}
.header-inner img{
  height:40px;
}
.header-title{
  font-size:20px;
  font-weight:600;
  color:var(--primary);
}

</style>


</head>
<body>
<header class="site-header">
  <div class="header-inner">
    <img src="../images/ailogo.png"
         alt="AGRIntelligence logo"
         onerror="this.style.display='none'">
  </div>
</header>

<div class="wrap">
  <div style="display:flex;align-items:center;justify-content:space-between;margin-bottom:12px;">
    <h1>Roadmap</h1>
    <a href="index.php" class="btn">Back to Feature Requests</a>
  </div>
  <p class="muted" style="margin-bottom:16px;">Columns show the current status of ideas. Card order is by total votes, then recency.</p>
  <div class="board">
    <?php foreach ($cols as $sid => $label): ?>
      <div class="col">
        <h2>
          <span><?php echo htmlspecialchars($label); ?></span>
          <span class="muted"><?php echo count($data[$sid] ?? []); ?> items</span>
        </h2>
        <?php if (empty($data[$sid])): ?>
          <div class="muted" style="margin:4px 6px;">No items yet.</div>
        <?php else: ?>
          <?php foreach ($data[$sid] as $f): ?>
            <div class="card">
              <div><strong><?php echo htmlspecialchars($f['title']); ?></strong>
                <?php if (!empty($f['category_name'])): ?>
                  <span class="badge"><?php echo htmlspecialchars($f['category_name']); ?></span>
                <?php endif; ?>
                <?php if (!empty($f['duplicate_of'])): ?>
                  <span class="badge">Dup of #<?php echo (int)$f['duplicate_of']; ?></span>
                <?php endif; ?>
              </div>
              <?php if (!empty($f['description'])): ?>
                <div class="muted"><?php echo nl2br(htmlspecialchars($f['description'])); ?></div>
              <?php endif; ?>
              <div class="muted">
                Votes: <?php echo (int)$f['total_votes']; ?> ·
                Created: <?php echo htmlspecialchars(substr($f['created_at'],0,10)); ?>
              </div>
            </div>
          <?php endforeach; ?>
        <?php endif; ?>
      </div>
    <?php endforeach; ?>
  </div>
</div>
</body>
</html>
