<?php
// === public/api.php (mysqli version) ===
require __DIR__ . '/../db.php';
header('Content-Type: application/json');

$action = $_GET['action'] ?? '';
if ($action !== 'features_list' && $action !== 'csrf') {
  require_csrf();
}

function read_json() {
  $in = file_get_contents('php://input');
  $data = json_decode($in, true);
  return is_array($data) ? $data : [];
}
function json_out($data, int $code = 200) {
  http_response_code($code);
  echo json_encode($data);
  exit;
}

switch ($action) {
  case 'csrf':
    json_out(['csrf' => $_SESSION['csrf']]);

  case 'features_list':
    $sort = $_GET['sort'] ?? 'top';
    $category = $_GET['category'] ?? null;
    $status = $_GET['status'] ?? null;

    $where = []; $params=[];
    if ($category) { $where[] = "f.category = ?"; $params[] = $category; }
    if ($status)   { $where[] = "f.status_id = ?"; $params[] = (int)$status; }
    $w = $where ? ("WHERE ".implode(" AND ", $where)) : "";

    if ($sort==='new') {
      $order = "ORDER BY f.created_at DESC";
    } elseif ($sort==='trending') {
      $order = "ORDER BY recent_votes DESC, total_votes DESC, f.created_at DESC";
    } else { // top
      $order = "ORDER BY total_votes DESC, f.created_at DESC";
    }

    $sql = "
      SELECT f.*,
        COALESCE(tv.total_votes,0) AS total_votes,
        COALESCE(rv.recent_votes,0) AS recent_votes
      FROM features f
      LEFT JOIN (
        SELECT feature_id, COUNT(*) total_votes
        FROM feature_votes GROUP BY feature_id
      ) tv ON tv.feature_id=f.id
      LEFT JOIN (
        SELECT feature_id, COUNT(*) recent_votes
        FROM feature_votes
        WHERE created_at >= (NOW() - INTERVAL 30 DAY)
        GROUP BY feature_id
      ) rv ON rv.feature_id=f.id
      $w
      $order
      LIMIT 200";
    $rows = $db->queryAll($sql, $params);
    json_out($rows);

  case 'features_create':
    $data = read_json();
    $title = trim($data['title'] ?? '');
    $desc  = trim($data['description'] ?? '');
    if ($title==='') json_out(['error'=>'title_required'], 422);
    $db->exec("INSERT INTO features (title, description, author_id) VALUES (?,?,?)",
              [$title, $desc, current_user_id($db)]);
    json_out(['ok'=>true, 'id'=>$db->lastId()]);

  case 'vote_toggle':
    $data = read_json();
    $fid = (int)($data['feature_id'] ?? 0);
    if (!$fid) json_out(['error'=>'feature_id_required'], 422);
    $uid = current_user_id($db);

    $exists = $db->queryOne("SELECT 1 FROM feature_votes WHERE feature_id=? AND user_id=?", [$fid, $uid]);
    if ($exists) {
      $db->exec("DELETE FROM feature_votes WHERE feature_id=? AND user_id=?", [$fid, $uid]);
      json_out(['ok'=>true, 'action'=>'unvoted']);
    } else {
      $db->exec("INSERT INTO feature_votes (feature_id, user_id) VALUES (?,?)", [$fid, $uid]);
      json_out(['ok'=>true, 'action'=>'voted']);
    }

  case 'comments_create':
    $data = read_json();
    $fid = (int)($data['feature_id'] ?? 0);
    $body = trim($data['body'] ?? '');
    if (!$fid || $body==='') json_out(['error'=>'invalid'], 422);
    $db->exec("INSERT INTO feature_comments (feature_id,user_id,body) VALUES (?,?,?)",
              [$fid, current_user_id($db), $body]);
    json_out(['ok'=>true]);

  case 'feature_set_status':
    $data = read_json();
    $fid = (int)($data['feature_id'] ?? 0);
    $sid = (int)($data['status_id'] ?? 0);
    if (!$fid || !$sid) json_out(['error'=>'invalid'], 422);
    $db->exec("UPDATE features SET status_id=? WHERE id=?", [$sid, $fid]);
    json_out(['ok'=>true]);

  default:
    json_out(['error'=>'unknown_action'], 400);
}
