<?php
require __DIR__ . '/../db.php';

$token = $_GET['token'] ?? '';
if (!$token) {
  echo "Missing token.";
  exit;
}

$row = $db->queryOne(
  "SELECT id FROM users WHERE magic_token=? AND magic_token_expires >= NOW()",
  [$token]
);

if (!$row) {
  echo "This link is invalid or has expired. Please request a new magic link.";
  exit;
}

// Log the user in
$_SESSION['user_id'] = (int)$row['id'];
$db->exec("UPDATE users SET magic_token=NULL, magic_token_expires=NULL, email_verified_at = IF(email_verified_at IS NULL,NOW(),email_verified_at), last_seen_at=NOW() WHERE id=?", [$row['id']]);

header("Location: index.php");
exit;
