<?php
// === db.php (mysqli-only) ===
$config = require __DIR__ . '/config.php';
if (file_exists(__DIR__ . '/config.local.php')) {
  $config = array_merge($config, require __DIR__ . '/config.local.php');
}

ini_set('display_errors', $config['app_debug'] ? '1' : '0');
error_reporting($config['app_debug'] ? E_ALL : 0);

session_name($config['session_name'] ?? 'fb_min_sess');
session_start();

// CSRF
if (empty($_SESSION['csrf'])) $_SESSION['csrf'] = bin2hex(random_bytes(16));
function require_csrf() {
  $m = $_SERVER['REQUEST_METHOD'] ?? 'GET';
  if (in_array($m, ['POST','PUT','PATCH','DELETE'])) {
    $hdr = $_SERVER['HTTP_X_CSRF_TOKEN'] ?? '';
    if (!$hdr || !hash_equals($_SESSION['csrf'], $hdr)) {
      http_response_code(419);
      header('Content-Type: application/json');
      echo json_encode(['error'=>'csrf_failed']); exit;
    }
  }
}

// Parse DSN like mysql:host=HOST;port=3306;dbname=featureboard;charset=utf8mb4
$host='127.0.0.1'; $port=3306; $dbname='featureboard';
if (preg_match('/host=([^;]+)/',$config['db_dsn'],$m)) $host=$m[1];
if (preg_match('/port=(\d+)/',$config['db_dsn'],$m)) $port=(int)$m[1];
if (preg_match('/dbname=([^;]+)/',$config['db_dsn'],$m)) $dbname=$m[1];

$mysqli = mysqli_init();
$mysqli->options(MYSQLI_OPT_INT_AND_FLOAT_NATIVE, 1);
if (!$mysqli->real_connect($host, $config['db_user'], $config['db_pass'], $dbname, $port)) {
  http_response_code(500);
  echo "DB connect failed (mysqli): " . htmlspecialchars($mysqli->connect_error); exit;
}
$mysqli->set_charset('utf8mb4');

class DB {
  public $db;
  function __construct($db){ $this->db=$db; }
  function queryAll($sql,$params=[]){
    $stmt=$this->prep($sql,$params); $res=$stmt->get_result();
    $rows=[]; if ($res) { while($r=$res->fetch_assoc()) $rows[]=$r; }
    $stmt->close(); return $rows;
  }
  function queryOne($sql,$params=[]){
    $rows=$this->queryAll($sql,$params); return $rows ? $rows[0] : null;
  }
  function exec($sql,$params=[]){
    $stmt=$this->prep($sql,$params); $stmt->close(); return true;
  }
  function lastId(){ return $this->db->insert_id; }
  private function prep($sql,$params){
    $stmt=$this->db->prepare($sql);
    if(!$stmt) throw new Exception($this->db->error);
    if ($params){
      $types=''; $values=[];
      foreach($params as $p){
        if (is_int($p)) { $types.='i'; }
        elseif (is_float($p)) { $types.='d'; }
        else { $types.='s'; }
        $values[]=$p;
      }
      $stmt->bind_param($types, ...$values);
    }
    if(!$stmt->execute()) throw new Exception($stmt->error);
    return $stmt;
  }
}
$db = new DB($mysqli);

// Minimal "user" per session
function current_user_id(DB $db) {
  if (!isset($_SESSION['user_id'])) {
    $name = 'Guest '.substr(bin2hex(random_bytes(3)),0,6);
    $db->exec("INSERT INTO users (email,name) VALUES (?,?)",[NULL,$name]);
    $_SESSION['user_id'] = (int)$db->lastId();
  }
  return (int)$_SESSION['user_id'];
}
