<?php
require __DIR__ . '/../db.php';
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <title>Feature Requests</title>
  <style>
    body{font-family:system-ui,-apple-system,Segoe UI,Roboto,Ubuntu,Cantarell,'Noto Sans','Helvetica Neue',Arial,'Apple Color Emoji','Segoe UI Emoji';margin:0;background:#f6f7fb;color:#222}
    .wrap{max-width:860px;margin:24px auto;padding:0 16px}
    .card{background:#fff;border:1px solid #e5e7eb;border-radius:12px;box-shadow:0 2px 6px rgba(0,0,0,0.04);padding:16px}
    .row{display:flex;gap:12px;align-items:center}
    .btn{border:1px solid #d1d5db;background:#fff;border-radius:10px;padding:8px 12px;cursor:pointer}
    .btn:hover{background:#f3f4f6}
    .vote{min-width:50px;text-align:center}
    .muted{color:#6b7280}
    .mb8{margin-bottom:8px}.mb16{margin-bottom:16px}.mb24{margin-bottom:24px}
    input,textarea,select{width:100%;border:1px solid #d1d5db;border-radius:10px;padding:8px}
    ul{list-style:none;padding:0;margin:0}
    li{margin-bottom:12px}
    .badge{font-size:12px;border:1px solid #e5e7eb;border-radius:999px;padding:2px 8px;margin-left:6px}
  </style>
</head>
<body>
  <div class="wrap">
    <h1 class="mb16">Feature Requests</h1>
    <div class="card mb16">
      <form id="idea-form">
        <div class="mb8"><input id="idea-title" placeholder="Short title (e.g., Bulk CSV import)"></div>
        <div class="mb8"><textarea id="idea-desc" rows="3" placeholder="Optional details"></textarea></div>
        <button class="btn" type="submit">Submit idea</button>
        <span class="muted" id="status-msg"></span>
      </form>
    </div>

    <div class="row mb16">
      <button class="btn sort" data-sort="top">Top</button>
      <button class="btn sort" data-sort="trending">Trending</button>
      <button class="btn sort" data-sort="new">New</button>
    </div>

    <ul id="ideas"></ul>
  </div>

<script>
let CSRF = null;
async function getCsrf() {
  const res = await fetch('api.php?action=csrf');
  const j = await res.json();
  CSRF = j.csrf;
}
function escapeHtml(s){return s.replace(/[&<>"']/g,m=>({ '&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#039;' }[m]));}

let currentSort = 'top';
async function loadIdeas() {
  const res = await fetch('api.php?action=features_list&sort='+encodeURIComponent(currentSort));
  const data = await res.json();
  const ul = document.getElementById('ideas');
  ul.innerHTML = data.map(it => {
    const votes = it.total_votes ?? 0;
    const badge = it.status_id==1 ? '' : `<span class="badge">${it.status_id}</span>`;
    const dt = new Date(it.created_at.replace(' ','T')+'Z').toLocaleString();
    return `<li class="card">
      <div class="row">
        <div class="vote">
          <button class="btn vote-btn" data-id="${it.id}">▲</button>
          <div>${votes}</div>
        </div>
        <div>
          <div><strong>${escapeHtml(it.title)}</strong>${badge}</div>
          <div class="muted">${escapeHtml(it.description || '')}</div>
          <div class="muted" style="font-size:12px">${dt}</div>
        </div>
      </div>
    </li>`;
  }).join('');
  document.querySelectorAll('.vote-btn').forEach(b=>{
    b.addEventListener('click', async e => {
      const id = e.currentTarget.dataset.id;
      const res = await fetch('api.php?action=vote_toggle', {
        method:'POST',
        headers:{'Content-Type':'application/json','X-CSRF-Token':CSRF},
        body: JSON.stringify({feature_id:Number(id)})
      });
      const j = await res.json();
      if (j.ok) loadIdeas();
    });
  });
}

document.querySelectorAll('.sort').forEach(b=>{
  b.addEventListener('click', ()=>{ currentSort = b.dataset.sort; loadIdeas(); });
});

document.getElementById('idea-form').addEventListener('submit', async e => {
  e.preventDefault();
  const t = document.getElementById('idea-title').value.trim();
  const d = document.getElementById('idea-desc').value.trim();
  if (!t) { document.getElementById('status-msg').textContent='Title required'; return; }
  const res = await fetch('api.php?action=features_create', {
    method:'POST',
    headers:{'Content-Type':'application/json','X-CSRF-Token':CSRF},
    body: JSON.stringify({title:t, description:d})
  });
  const j = await res.json();
  if (j.ok) {
    document.getElementById('idea-form').reset();
    document.getElementById('status-msg').textContent='Submitted!';
    loadIdeas();
  } else {
    document.getElementById('status-msg').textContent='Failed to submit';
  }
});

(async function init(){
  await getCsrf();
  await loadIdeas();
})();
</script>
</body>
</html>
