<?php require __DIR__ . '/../db.php'; ?>
<!doctype html>
<html><head><meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title>Roadmap</title>
<style>
body{font-family:system-ui,-apple-system,Segoe UI,Roboto; background:#f6f7fb; margin:0}
.wrap{max-width:1200px;margin:24px auto;padding:0 16px}
.col{flex:1;min-width:260px}
.board{display:flex;gap:16px}
.card{background:#fff;border:1px solid #e5e7eb;border-radius:12px;box-shadow:0 2px 6px rgba(0,0,0,.04);padding:12px;margin-bottom:8px}
.h{font-weight:700;margin:6px 0 12px}
.badge{font-size:12px;border:1px solid #e5e7eb;border-radius:999px;padding:2px 8px;margin-left:6px}
</style></head>
<body>
<div class="wrap">
  <h1>Roadmap</h1>
  <div class="board">
    <div class="col"><div class="h">Planned</div><div id="col-planned"></div></div>
    <div class="col"><div class="h">In Progress</div><div id="col-progress"></div></div>
    <div class="col"><div class="h">Released</div><div id="col-released"></div></div>
  </div>
</div>
<script>
async function load(status, el){
  const r = await fetch('api.php?action=features_list&status='+status+'&sort=top');
  const data = await r.json();
  el.innerHTML = data.map(it=>`<div class="card"><div><strong>${it.title}</strong><span class="badge">▲ ${it.total_votes||0}</span></div><div>${(it.category_name||'')}</div></div>`).join('');
}
(async function(){
  await load(2, document.getElementById('col-planned'));
  await load(3, document.getElementById('col-progress'));
  await load(4, document.getElementById('col-released'));
})();
</script>
</body></html>
