<?php require __DIR__ . '/../db.php'; ?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8" /><meta name="viewport" content="width=device-width,initial-scale=1" />
<title>Feature Requests</title>
<style>
body{font-family:system-ui,-apple-system,Segoe UI,Roboto,Ubuntu,Cantarell,'Noto Sans','Helvetica Neue',Arial;margin:0;background:#f6f7fb;color:#222}
.wrap{max-width:960px;margin:24px auto;padding:0 16px}
.card{background:#fff;border:1px solid #e5e7eb;border-radius:12px;box-shadow:0 2px 6px rgba(0,0,0,.04);padding:16px}
.row{display:flex;gap:12px;align-items:center}
.btn{border:1px solid #d1d5db;background:#fff;border-radius:10px;padding:8px 12px;cursor:pointer}
.btn:hover{background:#f3f4f6}
.vote{min-width:50px;text-align:center}
.muted{color:#6b7280}
.mb8{margin-bottom:8px}.mb12{margin-bottom:12px}.mb16{margin-bottom:16px}
input,textarea,select{width:100%;border:1px solid #d1d5db;border-radius:10px;padding:8px}
ul{list-style:none;padding:0;margin:0} li{margin-bottom:12px}
.badge{font-size:12px;border:1px solid #e5e7eb;border-radius:999px;padding:2px 8px;margin-left:6px}
.col{flex:1;min-width:260px}
</style>
</head>
<body>
<div class="wrap">
  <h1 class="mb16">Feature Requests</h1>

  <div class="card mb16">
    <div class="row mb12">
      <input id="email" placeholder="your.name@company.com" style="max-width:320px">
      <button class="btn" id="btn-auth">Set Email</button>
      <a class="btn" href="admin.php">Admin</a>
      <span class="muted" id="auth-msg"></span>
    </div>
    <form id="idea-form">
      <div class="mb8"><input id="idea-title" placeholder="Short title (e.g., Bulk CSV import)"></div>
      <div class="mb8"><textarea id="idea-desc" rows="3" placeholder="Optional details"></textarea></div>
      <div class="mb8">
        <select id="idea-category"></select>
      </div>
      <div class="mb8">
        <small class="muted">We’ll check for duplicates as you type.</small>
        <ul id="dups" class="muted"></ul>
      </div>
      <button class="btn" type="submit">Submit idea</button>
      <span class="muted" id="status-msg"></span>
    </form>
  </div>

  <div class="row mb16">
    <button class="btn sort" data-sort="top">Top</button>
    <button class="btn sort" data-sort="trending">Trending</button>
    <button class="btn sort" data-sort="new">New</button>
    <select id="filter-category" class="btn"></select>
  </div>

  <ul id="ideas"></ul>

  <div class="card mb16">
    <a class="btn" href="roadmap.php">Open Roadmap</a>
  </div>
</div>

<script>
let CSRF = null;
async function api(path,opts={}){
  const o = Object.assign({headers:{}},opts);
  if (!o.headers['Content-Type'] && o.body) o.headers['Content-Type']='application/json';
  if (!o.headers['X-CSRF-Token']) o.headers['X-CSRF-Token']=CSRF;
  const r = await fetch('api.php'+path, o);
  return r.json();
}
async function getCsrf(){ const j = await api('?action=csrf', {headers:{}}); CSRF=j.csrf; }

async function loadCategories(){
  const cats = await api('?action=categories_list',{headers:{}});
  const sel = document.getElementById('idea-category');
  const filt = document.getElementById('filter-category');
  sel.innerHTML = '<option value="">Select category (optional)</option>' + cats.map(c=>`<option value="${c.id}">${c.name}</option>`).join('');
  filt.innerHTML = '<option value="">All categories</option>' + cats.map(c=>`<option value="${c.id}">${c.name}</option>`).join('');
}

function escapeHtml(s){return (s||'').replace(/[&<>"']/g,m=>({ '&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',\"'\":'&#039;' }[m]));}

let currentSort = 'top';
async function loadIdeas(){
  const catId = document.getElementById('filter-category').value;
  const res = await fetch('api.php?action=features_list&sort='+encodeURIComponent(currentSort)+(catId?('&category_id='+catId):''));
  const data = await res.json();
  const ul=document.getElementById('ideas');
  ul.innerHTML = data.map(it=>{
    const votes = it.total_votes ?? 0;
    const badge = it.status_id==1 ? '<span class="badge">Backlog</span>' :
                 it.status_id==2 ? '<span class="badge">Planned</span>' :
                 it.status_id==3 ? '<span class="badge">In Progress</span>' :
                 it.status_id==4 ? '<span class="badge">Released</span>' :
                 it.status_id==5 ? '<span class="badge">Declined</span>' : '';
    const cat = it.category_name ? `<span class="badge">${escapeHtml(it.category_name)}</span>`:'';
    const dup = it.duplicate_of ? `<span class="badge">Dup of #${it.duplicate_of}</span>` : '';
    const dt = new Date(it.created_at.replace(' ','T')+'Z').toLocaleString();
    return `<li class="card">
      <div class="row">
        <div class="vote">
          <button class="btn vote-btn" data-id="${it.id}">▲</button>
          <div>${votes}</div>
        </div>
        <div>
          <div><strong>${escapeHtml(it.title)}</strong> ${badge} ${cat} ${dup}</div>
          <div class="muted">${escapeHtml(it.description||'')}</div>
          <div class="muted" style="font-size:12px">${dt}</div>
        </div>
      </div>
    </li>`;
  }).join('');
  document.querySelectorAll('.vote-btn').forEach(b=>{
    b.addEventListener('click', async e=>{
      const j = await api('?action=vote_toggle',{method:'POST',body:JSON.stringify({feature_id:Number(b.dataset.id)})});
      if (j.ok) loadIdeas(); else alert(j.error||'Vote failed');
    });
  });
}

document.querySelectorAll('.sort').forEach(b=>{
  b.addEventListener('click', ()=>{ currentSort=b.dataset.sort; loadIdeas(); });
});
document.getElementById('filter-category').addEventListener('change', loadIdeas);

// auth by email
document.getElementById('btn-auth').addEventListener('click', async ()=>{
  const email = document.getElementById('email').value.trim();
  if(!email) { document.getElementById('auth-msg').textContent='Enter email'; return; }
  const j = await api('?action=auth_email',{method:'POST',body:JSON.stringify({email})});
  document.getElementById('auth-msg').textContent = j.ok ? 'Email set' : (j.error || 'Failed');
});

// duplicate suggestions as user types (levenshtein)
const titleEl = document.getElementById('idea-title');
titleEl.addEventListener('input', async ()=>{
  const q = titleEl.value.trim(); const list=document.getElementById('dups');
  if (q.length<3){ list.innerHTML=''; return; }
  const r = await fetch('api.php?action=duplicate_suggest_lev&q='+encodeURIComponent(q));
  const data = await r.json();
  list.innerHTML = data.map(d=>`<li>Close match: “${escapeHtml(d.title)}” (distance ${d.distance})</li>`).join('');
});

// submit idea
document.getElementById('idea-form').addEventListener('submit', async e=>{
  e.preventDefault();
  const title = document.getElementById('idea-title').value.trim();
  const desc  = document.getElementById('idea-desc').value.trim();
  const catId = document.getElementById('idea-category').value || null;
  if (!title) { document.getElementById('status-msg').textContent='Title required'; return; }
  const j = await api('?action=features_create',{method:'POST',body:JSON.stringify({title,description:desc,category_id: catId?Number(catId):null})});
  if (j.ok){ e.target.reset(); document.getElementById('dups').innerHTML=''; document.getElementById('status-msg').textContent='Submitted!'; loadIdeas(); }
  else { document.getElementById('status-msg').textContent=j.error||'Failed'; }
});

(async function init(){
  const s = await fetch('api.php?action=settings_get'); const conf = await s.json();
  document.getElementById('email').placeholder = 'your.name@'+(conf.allowed_domain || 'company.com');
  await getCsrf();
  await loadCategories();
  await loadIdeas();
})();
</script>
</body>
</html>
